/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ServerPerformanceMonitor {
    private static final int sampleNum = 20;
    private static PerformanceLevel level = PerformanceLevel.bad;
    private static final LimitedLogger limitedLogger = new LimitedLogger(50);
    private static long lastUpdateTime = 0L;

    public static void init() {
        IPGlobal.postServerTickSignal.connect(ServerPerformanceMonitor::tick);
    }

    private static void tick() {
        if (!IPGlobal.enableServerPerformanceAdjustment) {
            level = PerformanceLevel.good;
            return;
        }
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            return;
        }
        if (!server.m_130010_()) {
            return;
        }
        long currTime = System.nanoTime();
        if (currTime - lastUpdateTime < Helper.secondToNano(20.0)) {
            return;
        }
        lastUpdateTime = currTime;
        float tickTime = server.m_129903_();
        PerformanceLevel newLevel = PerformanceLevel.getServerPerformanceLevel(tickTime);
        if (newLevel != level) {
            level = newLevel;
            limitedLogger.log("Server performance level: " + String.valueOf((Object)newLevel));
        }
    }

    public static PerformanceLevel getLevel() {
        return level;
    }
}

